<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  
  define('INDEXU', 1);

  /*===================================================
    register_globals & magic_quotes_gpc = on
  ===================================================*/
  function safe_extract($var) {
    static $forbidden = array('_FILES', '_ENV', '_GET', '_POST', '_COOKIE', '_SERVER', '_SESSION', 'GLOBALS');
    while (list($k, $v) = @each($var)) {
      if (!in_array($k, $forbidden)) {
        $GLOBALS[$k] = $v;
      }
      else {
        exit;
      }
    }
  }
  function addslashes_deep($value) {
     $value = is_array($value) ? array_map('addslashes_deep', $value) : addslashes($value);
     return $value;
  }
  if (!get_magic_quotes_gpc()) {
    if (!empty($_GET)) {
      $_GET = addslashes_deep($_GET);
      safe_extract($_GET);
    }
    if (!empty($_POST)) {
      $_POST = addslashes_deep($_POST);
      safe_extract($_POST);
    }
    if (!empty($_COOKIE)) {
      $_COOKIE = addslashes_deep($_COOKIE);
      safe_extract($_COOKIE);
    }
  }
  elseif (!ini_get('register_globals')) {
    if (!empty($_GET)) safe_extract($_GET);
    if (!empty($_POST)) safe_extract($_POST);
    if (!empty($_COOKIE)) safe_extract($_COOKIE);
  }


  /*===================================================
    config
  ===================================================*/

  $dbServer               = "mysql";
  $dbHostname             = "<%$dbHostname%>";
  $dbUsername             = "<%$dbUsername%>";
  $dbPassword             = "<%$dbPassword%>";
  $dbName                 = "<%$dbName%>";

  $site_url               = "<%$site_url%>";
  $base_path              = "<%$base_path%>";
  $theme_path             = $base_path . "themes/";
  $admin_template_path    = $base_path . "admin_tpl/";

  $site_name              = "<%$site_name%>";

  $active_theme           = '<%$active_theme%>';

  $email_address          = "<%$email_address%>";

  $spam_proof             = <%$spam_proof%>;
  $enable_user_validation = <%$enable_user_validation%>;

  $allowed_file_extension = "<%$allowed_file_extension%>";
  $google_key             = "<%$google_key%>";
  $whosonline             = "<%$whosonline%>";
  $reciprocal_check       = <%$reciprocal_check%>;
  $urlcheck_limit         = <%$urlcheck_limit%>;    // days for re-check url
  $pagerank_cache         = <%$pagerank_cache%>;    // days caching pagerank

  $max_image_width        = <%$max_image_width%>;   // in pixel
  $max_image_height       = <%$max_image_height%>;  // in pixel
  $max_file_size          = <%$max_file_size%>;    // in KB

  $only_registered_can_add_link = <%$only_registered_can_add_link%>;
  $only_registered_can_add_review = <%$only_registered_can_add_review%>;
  $db_use_persistent      = <%$db_use_persistent%>;

  $paid_link_day_period   = "<%$paid_link_day_period%>";
  $paid_link_price_factor = "<%$paid_link_price_factor%>";

  $enable_html_tag        = <%$enable_html_tag%>;
  $allowed_html_tag       = "<%$allowed_html_tag%>";

  $enable_page_compression = <%$enable_page_compression%>;


  /*===================================================
    include
  ===================================================*/

  include $base_path . "lib/db.class.php";
  include $base_path . "lib/users.class.php";
  include $base_path . "lib/category.class.php";
  include $base_path . "lib/link.class.php";
  include $base_path . "lib/mailing_list.class.php";
  include $base_path . "lib/pagination.class.php";
  include $base_path . "lib/auth/auth.class.php";
  include $base_path . "lib/template.lib.php";
  include $base_path . "lib/form_validation.lib.php";
  include $base_path . "lib/mod-rewrite.lib.php";
  include $base_path . "lib/http.lib.php";
  include $base_path . "lib/filter.lib.php";
  include $base_path . "lib/payment.lib.php";
  include $base_path . "lib/misc.lib.php";
  include $base_path . "init.php";


  /*===================================================
    php configuration
  ===================================================*/

  ini_set("max_execution_time", "60");
  ini_set("session.use_trans_sid", false);
  ini_set("session.use_only_cookies", true);
  ini_set("url_rewriter.tags", "");

  $indexu_version = "5.3.0";

?>